############################ Estimation #################################

################################################# set 'working Directory'
setwd("D:/AS17 translation/AS17 supplements")
opar <- par() 
#options(warn=-1)
#########################################################################

                                                            # Section 6.2

                                                 # random numbers, sample
set.seed(123)
runif(5, min=0, max=1)  # 5 random numbers between 0 und 1 uniformly distributed
rnorm(5, mean=0, sd=1)  # 5 random numbers standard normally distributed         

#########################################################################

sample(1:80, 20, replace=FALSE)

#########################################################################

                                                          # Section 6.4.2 

                              # maximum likelihood estimation - coin toss
n  <- 10; p  <- 1/2; x  <- 0:n
fx <- dbinom(x, n, p)   
                                                             # figure 6.2
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)

plot(x, fx, type="h", ylim=c(0, 0.3), xlim=c(0,n), las=1, 
     ylab="P(X=x)", xlab=" ", lty=2, col="grey")
points(x, fx, pch=19, cex=1.1, col="black")

p  <- seq(0, 1, by=0.01)
Lx <- dbinom(9, n, p) 
plot(p, Lx, type="l", ylim=c(0,0.4), las=1,
     xlim=c(0,1), ylab="L(p)", xlab=" ")
points(0.9, dbinom(9, n, 0.9), pch=19, cex=1.5, col="black")
lines(c(0.9,0.9), c(0,dbinom(9, n, 0.9)), lty=2, col="grey")

#########################################################################

                                                      # Abschnitt 6.4.2.1

                                  # MLE binomial distribution - coin toss
library(bbmle)
x    <- 16                                 # 16 times the six
size <- 24                                 # number of throws 24    
                                           # p=1/6 initial ideal assumed        
logL <- function(p = 1/6) -sum(stats::dbinom(x,  size, p, log = TRUE))
mle2(logL)   

#########################################################################

                                            # functions in library(bbmle)
est  <- mle2(logL); summary(est)
                                            # likelihood - profile
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=11)
profile(est); plot(profile(est))
                                 
confint(est)                                # confidence limits

#########################################################################

                                                        # Section 6.4.2.2

                                     # MLE negative binomial distribution
                                                                                                  
d3f <- 0:47                                         # example caries 
n   <- c(221, 32, 42, 27, 27, 13, 11, 9, 8, 14, 6, 5, 4, 7, 
           6, 4, 4, 1, 1, 3, 3, 3, 3, 0, 1, 1, 0, 1, 1, 0, 0, 
           1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1)
N   <- sum(n)                                       # moments estimation
m   <- sum(n*d3f)/N; m                              # mean       
v   <- (sum(n*(d3f^2))-(sum(n*d3f))^2/N)/(N-1); v   # variance          
 
prob <- m/v; prob                                   # p estimated     
size <- m^2/(v-m); size                             # k estimated     

#########################################################################

library(bbmle)
logL <- function(k=size, p=prob) -sum(stats::dnbinom(n, k, p, log=TRUE))
summary(mle2(logL))

#########################################################################

dnbinom(0:47, size, prob, log = FALSE)

#########################################################################

                                                      # Abschnitt 6.4.2.4

                                                # MLE normal distribution

x    <- c(23, 25, 30, 18, 17, 24, 23, 20, 19)      # observations
# ##########  expected value =20 and variance =16 initial ###############
library(bbmle)
logL <- function(m=20, s=4) -sum(stats::dnorm(x, mean=m, sd=s, log=TRUE))
mle2(logL)
mean(x); sd(x)                                      # analytical solution 

#########################################################################

library(MASS)
set.seed(123);                          
x <- rnorm(20, mean=80, sd=15)                     # random numbes                
fitdistr(x, "normal")                              # MLE

#########################################################################

x    <- c(23, 25, 30, 18, 17, 24, 23, 20, 19)      # observations       
fitdistr(x, "normal")                              # MLE

#########################################################################

                                                        # Section 6.4.2.5

                                      # MLE truncated normal distribution
# partikel <- rnorm(30, mean = 8, sd = 2)   
# filter   <- partikel[partikel >= 0 & partikel<9]

library(fitdistrplus); library(extraDistr)
filter <- c(4.98, 8.60, 6.37, 4.37, 8.03, 7.43, 6.83, 5.64, 5.43, 6.88,
            4.57, 7.50, 5.69, 7.88, 8.98, 6.79, 8.61, 6.70, 5.14, 7.29) 

fit  <- fitdist(filter, dtnorm, fix.arg=list(a=-Inf, b=9),
                start=list(mean=mean(filter), sd=sd(filter)),
                optim.method="L-BFGS-B", 
                lower=c(-0.1, -0.1), upper=c(Inf, Inf)) 
summary(fit)

plot(fit)

########################################################################

x     <- seq(0, 14, 0.02)
f1    <- dnorm(x, mean=8, sd=2)
f11   <- pnorm(x, mean=8, sd=2)
fitm  <- fit$estimate[1]
fits  <- fit$estimate[2]
f2    <- dtnorm(x, mean=fitm, sd=fits, a=0, b=9)
f22   <- ptnorm(x, mean=fitm, sd=fits, a=0, b=9)
mx    <- which(x == 9); trunc <- which(x == 9)
                                                            # figure 6.3
par(mfrow=c(1,2), lwd=1.5, font.axis=2, bty="l", ps=14)
plot(x, f1, las=1, type="l", lwd=2, lty=2, 
     xlim=c(0,14), ylim=c(0,0.35), ylab="f(x)",
     xlab="Particle size", col="red" )
lines(x[1:trunc], f2[1:trunc], lwd=2, lty=1, col="blue")
lines(c(8, 8), c(0, f1[mx]), col="red", lty=2, lwd=2)
lines(c(fitm, fitm), c(0, dtnorm(fitm, mean=fitm, 
                                 sd=fits, a=0, b=9)), col="blue", lty=1, lwd=2)
text(2, 0.25, expression(paste(hat(mu), " = 7.04")), cex=1.4)
text(2, 0.20, expression(paste(hat(sigma), " = 1.62")), cex=1.4)

plot(x, f11, las=1, type="l", lwd=2, lty=2, 
     xlim=c(0,14), ylim=c(0,1), ylab="F(x)",
     xlab="Particle size", col="red" )
lines(x[1:trunc], f22[1:trunc], lwd=2, lty=1, col="blue")
lines(c(x[trunc],x[trunc]), c(0,1), lwd=2, col="blue")
lines(c(8, 8), c(0, 0.5), col="red", lty=2, lwd=2)
lines(c(0, 8), c(0.5, 0.5), col="blue", lty=2, lwd=2)

#########################################################################

                                                          # Section 6.4.3

                            # estimation according to least squares error
                                                          
x1 <- seq(0, 10, by=0.5)                       # linear model
n1 <- length(x1)
set.seed(123); e1 <- rnorm(n1, mean=0, sd=3)   # noise                
y1 <- 20 - 5*x1 + e1                           # parameter a=20 and b=5  
lm(y1 ~ x1)                                    
#########################################################################
x2 <- seq(0,10, by=0.2)                         # nonlinear model
n2 <- length(x2)
set.seed(123); e2 <- rnorm(n2, mean=0, sd=0.5)  # noise               
y2 <- 5/exp(0.5*x2) + e2                     # parameter p1=5 and p2=0.5 
nls(y2 ~ p1/exp(p2*x2), start=list(p1=1, p2=1))           

#########################################################################

                                                             # figure 6.4
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)

plot(x1, y1, type="p", ylim=c(-30, 20), xlim=c(0,10), las=1, 
     cex.lab = 1.3, ylab=expression(y==a+bx), xlab=" ")
lines(x1, 21.7 - 5.26 * x1, lty=2, cex=1.0, col="black")

plot(x2, y2, type="p", ylim=c(0,5), xlim=c(0,10), las=1, cex.lab = 1.3,
                       ylab=expression(y==p[1]/exp(p[2]*x)), xlab=" ")
lines(x2, 5.49 / exp(0.65 * x2) , lty=2, col="black")


#########################################################################

                                                            # Section 6.5

                                               # CI - interval estimation
pi.hat  <- 0.6
n       <- 10
pi      <- seq(0, 1, 0.01)

confidence <- function(pi.hat, n, pi) {
  sd.hat <- sqrt(pi.hat*(1-pi.hat)/n)
  z      <- abs(pi.hat - pi)/sd.hat
  alpha  <- pnorm(z); 1-alpha        }

                                                             # figure 6.5
par(lwd=2, font.axis=2, bty="l", ps=15, mfrow=c(1,1))
plot(pi, confidence(pi.hat, 10, pi), las=1, type="l", lty=1,
     ylab="alpha", xlab="Probability")
lines(pi, confidence(pi.hat, 25, pi), lty=2)
lines(pi, confidence(pi.hat, 100, pi), lty=3)
abline(h=0.05)
text(0.2, 0.07,"90%-Confidence limits", cex=1.2)
abline(v=pi.hat-qnorm(0.95)* sqrt(pi.hat*(1-pi.hat)/n))
abline(v=pi.hat+qnorm(0.95)* sqrt(pi.hat*(1-pi.hat)/n)) 
text(0.40, 0.15, "n=10")
text(0.45, 0.11, "n=25")
text(0.50, 0.08, "n=100")

#########################################################################
                                                                                                    
library(gplots)                                                 # CI plot
par <- c(1.0, 2.0, 1.5)
upp <- c(1.2, 2.3, 2.1); low <- c(0.8, 1.7, 1.0)
                                                             # figure 6.5
par(mfrow=c(1,1), lwd=2, bty="n", font=1, font.axis=2, ps=15)

plotCI(par, ui=upp, li=low, xlim=c(0.8, 3.2), ylim=c(0.5, 2.5), 
       las=1, xaxt="n", ylab="Parameter - Confidence Interval", xlab=" ")
axis(side=1, at=1:3, labels=c("Sample 1", "Sample 2", "Sample 3"), cex=0.7)
abline(h=seq(0.5, 2.5, 0.5), lty=2, col="grey")

#########################################################################

                                                            # Section 6.6

                                              # CI binomial probabilities

n <- 20; x <- 7                               # Fisher distribution 
piu <- x/(x+(n-x+1)*qf(0.975, 2*(n-x+1), 2*x)); piu
pio <- (x+1) * qf(0.975, 2*(x+1), 2*(n-x)) / 
       (n-x+(x+1) * qf(0.975, 2*(x+1), 2*(n-x))); pio

#########################################################################

                                  # CI exact according to Clopper-Pearson
CI.Clopper <- function(x, n, conflev) {
           phat   <- x / n
           level  <- (1-conflev)/2
           lowlim <- qbeta(level, x, n-x+1)
           uplim  <- qbeta(1-level, x+1, n-x)          
cat(" \nCI (Clopper/Pearson) with coverage probabilities",conflev,
    " \nand the estimation", round(phat,digits=4), "results in the lower",
    " \nupper confidence limit:", round(lowlim,digits=4),"-", 
round(uplim,digits=4)," \n")          } 
CI.Clopper(7, 20, 0.95)


#########################################################################

x <- 100;  k <- 20                                 # prevalence estimates
conflev <- 0.95; level  <- (1-conflev)/2
phat   <- (k-1) / (x+k-1); round(phat, 3)
lowlim <- qbeta(level, k, x+1); round(lowlim, 3)
uplim  <- qbeta(1-level, k, x); round(uplim, 3)

#########################################################################

                                                          # Section 6.6.1
                                                    
CI.Binom <- function(x, n, conflev) {                    # approximations      
        phat   <- x / n
        zalpha <- abs(qnorm((1-conflev)/2))           # CI Wald statistic   
        bound  <- 1/(2*n) + zalpha*sqrt(phat*(1-phat)/n) 
        low1   <- phat - bound; upp1   <- phat + bound
                                                     # CI Wilson interval  
        midpnt <- (x + (zalpha**2/2))/(n + zalpha**2)    
        bound  <- zalpha*(sqrt(n)/(n+zalpha**2))*
                    sqrt(phat*(1-phat)+zalpha**2/(4*n))
        upp2   <- midpnt + bound;       low2   <- midpnt - bound                   
cat("With coverage probability", conflev,"and the estimate", 
    round(phat,digits=4),
    "\nthe approximate lower and upper confidence limit according to", 
    "\n Wald statistic  :",round(low1,digits=4),"-", round(upp1,digits=4),
    "\n Wilson interval:",round(low2,digits=4),"-", round(upp2,digits=4)," \n") 
} 
CI.Binom(70, 200, 0.95)
CI.Binom(7, 20, 0.95)

#########################################################################

                                                          # Section 6.6.4
                                                        
                                          # difference of two proportions
                                              
ci.wald <- function(x1, n1, x2, n2, conflev) { # Wals statistic (stadard)
           zalpha <- abs(qnorm((1-conflev)/2))
           p1 <- x1/n1; p2 <- x2/n2;           delta  <- p1 - p2                 
           adj    <- ifelse(delta<0, 0.5*(1/n1 + 1/n2), -0.5*(1/n1 + 1/n2))
           bound  <- zalpha*sqrt(p1*(1-p1)/n1 + p2*(1-p2)/n2)
           lowlim <- delta + adj - bound;      upplim <- delta + adj + bound
cat(" \nCI after Wald: For the", 100*conflev, "%-CI for the estimate",
round(p1 - p2,digits=4), "\nlower and upper limits are:", 
round(lowlim,digits=4),"-", round(upplim,digits=4)," \n")
}
ci.wald(140, 200, 150, 250, 0.95) 

#########################################################################
                                                           
ci.wilson <- function(x1, n1, x2, n2, conflev) {  # Wilson score statistic
           z  <- abs(qnorm((1-conflev)/2))
           p1 <- x1/n1; p2 <- x2/n2     
           phi1 <- (2*x1 + z^2)/(2*(n1 + z^2)); phi2 <- (2*x2 + z^2)/(2*(n2 + z^2))
           psi1 <- x1^2/(n1^2 + n1*z^2);        psi2 <- x2^2/(n2^2 + n2*z^2)
           l1   <- phi1 - sqrt(phi1^2 - psi1);  l2   <- phi2 - sqrt(phi2^2 - psi2)
           u1   <- phi1 + sqrt(phi1^2 - psi1);  u2   <- phi2 + sqrt(phi2^2 - psi2)
           delta <- sqrt((p1 - l1)^2 + (u2 - p2)^2)
           epsil <- sqrt((u1 - p1)^2 + (p2 - l2)^2)
           lowlim <- (p1 - p2) - delta;         upplim <- (p1 - p2) + epsil
cat(" \nCI after Wilson: For the", 100*conflev, "%-CI for the estimate",
round(p1 - p2,digits=4), "\nlower and upper limits are:", 
round(lowlim,digits=4),"-", round(upplim,digits=4)," \n")
}
ci.wilson(140, 200, 150, 250, 0.95) 

#########################################################################

                                                          # Section 6.6.5
                                                        
                                               # ratio of two proportions 
ci.ratio <- function(x1, n1, x2, n2, conflev) {  
   z   <- abs(qnorm((1-conflev)/2))
   p1  <- x1/n1; p2 <- x2/n2; rr  <- p1/p2
                                             # adjusted Wald method
   low1 <- (n2/n1)*((x1+0.5)/(x2-0.5))*exp(-z*sqrt(1/(x2+0.5)+1/(x1+0.5)))
   upp1 <- (n2/n1)*((x1+0.5)/(x2-0.5))*exp(z*sqrt(1/(x2+0.5)+1/(x1+0.5)))
   x. <- x1 + x2; p.hat <- x2/x.             # score Wilson method 
   p.l <- (x./(x.+z^2))*(p.hat+(z^2/(2*x.)) + 
                  z*sqrt((1/x.)*(p.hat*(1-p.hat)+z^2/(4*x.))))
   p.u <- (x./(x.+z^2))*(p.hat+(z^2/(2*x.)) - 
                  z*sqrt((1/x.)*(p.hat*(1-p.hat)+z^2/(4*x.))))
   low2 <- n2*(1-p.l)/(n1*p.l);    upp2 <- n2*(1-p.u)/(n1*p.u)
cat("\nThe",100*conflev,"%-CI for the ration",round(rr,digits=2),
    "of two proportions", "\nresults from the lower and upper limit according to", 
 "\nWald statistic (adj.):",round(low1,digits=4),"-", round(upp1,digits=4),
 "\nWilson score         :",round(low2,digits=4),"-", round(upp2,digits=4),"\n")
}

ci.ratio(30, 40, 5, 50, 0.95)             # example likelihood ratio

#########################################################################

ci.ratio(11, 219, 1, 183, 0.95)           # example relative risk  

#########################################################################

                                                          # Section 6.6.6

                                # sample size for estimating a proportion

alpha <- 0.05; zalph <- qnorm(1-alpha/2)           # quantils (two sided)
                                                              # table 6.7
preci <- seq(0.01, 0.10, by=0.01)
width <- 2*preci; lw  <- length(width)
prob  <- c(0.01,seq(0.02, 0.10, by=0.02),seq(0.15, 0.50, by=0.05))
lp    <- length(prob)

ntab  <- matrix(rep(NA, lp*lw), ncol = lp, byrow = TRUE)
for (i in 1:lw) {
	for (j in 1:lp) ntab[i,j] <- ceiling(((2*zalph)/width[i])^2 * prob[j] * (1-prob[j])) }
ntab <- rbind(prob, ntab)
ntab <- cbind(c(NA,preci), ntab)
ntab	

#########################################################################

                                                     # example television
nprobN <- function(N, w, p, alpha) {
	zalpha <- qnorm(1-alpha/2); i <- w/2
	return(ceiling((N*(i/zalpha)^2 + N*p - N*p^2)/
					(N*(i/zalpha)^2 + p - p^2))) }

nprobN(1000, 0.20, 0.50, 0.05)

nprobN(1000, 0.20, 0.30, 0.05)				   

#########################################################################

p  <- c(seq(0.5, 0.05, by=-0.05), 0.04, 0.03,0.02,0.01); lp <- length(p)
cv <- c(0.10, 0.15, 0.20, 0.25); lcv <- length(cv)

                                                              # table 6.8
n  <- matrix(rep(NA, lp*lcv), ncol = lcv, byrow = TRUE)
for (i in 1:lp) { 
	for (j in 1:lcv) n[i,j] <- ceiling((1-p[i]) / (p[i]*cv[j]^2)) }
tab <- as.data.frame(cbind(p, n))
colnames(tab) <- c("p","10%","15%","20%","25%")	
tab										   

#########################################################################

                                                          # Section 6.6.7

                               # simultaneous CI multionamial proportions

CImultinom <- function(n, alpha=0.05) {              # after L.A. Goodman
    k <- length(n); N <- sum(n)
    cil <- rep(NA, k); ciu <- rep(NA, k)
    q   <- qchisq(1-alpha/k, df=1)
    for (i in 1:k) {
        T <- sqrt(q * (q + 4*n[i]*(N-n[i])/N))
        cil[i] <- (q + 2*n[i] - T) / (2*(N+q))
        ciu[i] <- (q + 2*n[i] + T) / (2*(N+q))
    }
    round(cbind(cil, p=n/N, ciu), 4)
}

xmpl <- c(56,72,73,59,62)
CImultinom(xmpl)

library(MultinomialCI)
multinomialCI(xmpl, alpha=0.05, verbose=F)

#########################################################################

                                # sample size for simultaneous estimation

nCImultinom <- function(k, d, alpha=0.05) {
    f <- rep(NA, k)
    for (m in 1:k) {
        z <- qnorm(p=1-alpha/(2*m))
        f[m] <- (z^2*(1/m)*(1-1/m))/d^2 
    }
    ceiling(max(f)) 
}

nCImultinom(k=5, d=0.06, alpha=0.05)

#########################################################################
                                                         
                                                            # Section 6.7

                      # CI for the expected value in Poisson distribution

ci.poisson <- function(k, n, conf.level=0.95) {
  alpha  <- 1 - conf.level
  lambda <- k/n
  l_l <- 1/(2*n) * qchisq(alpha/2, df=2*k)
  l_u <- 1/(2*n) * qchisq(1-alpha/2, df=2*k+2)
  cat("\nThe",conf.level,"confidence interval for",
      round(lambda, 4)," is [", round(l_l, 4),"-",round(l_u, 4),"] \n") 
}

#########################################################################

                                                     # example bird nests
n <- 40                                              # areas
k <- 44                                              # nests
ci.poisson(k=44, n=40, conf.level=0.95)

#########################################################################

                                                          # Section 6.7.3

                                          # CI for the ratio of two rates

ci.rate.pois <- function(k1, n1, k2, n2, conf.level=0.95) {
  alpha  <- 1 - conf.level
  lambda1 <- k1/n1; lambda2 <- k2/n2
  k <- k1; m <- k1+k2
  F  <- qf(0.975, 2*(m-k+1), 2*k); pl <- k/(k + (m-k+1)*F)
  F  <- qf(0.975, 2*(k+1), 2*(m-k)); pu <- (k+1)*F/(m-k+(k+1)*F)
  l_l <- n2*pl/(n1*(1-pl))
  l_u <- n2*pu/(n1*(1-pu))
  cat(" \nThe",conf.level,"confidence interval for the ratio of",
      round(lambda1, 4),"to",round(lambda2, 4),"is [",
      round(l_l, 4),"-",round(l_u, 4),"] \n") 
}

#########################################################################

ci.rate.pois(40, 20, 22, 30, conf.level=0.95)

#########################################################################

library(exactci)
poisson.exact(c(40, 22),c(20, 30))

#########################################################################

                    # approximation after W. Nelson; example failure rate
k1 <- 69; n1 <- 1079.6;  k2 <- 12; n2 <- 467.9
l1 <- k1/n1; l2 <- k2/n2; 
r.hat = l2/l1; r.hat
s.hat <- sqrt(1/k1+1/k2); s.hat
l_l <- r.hat/exp(1.96*s.hat); l_u <- r.hat*exp(1.96*s.hat)
round(l_l, 2); round(l_u, 2)

ci.rate.pois(12, 467.9, 69, 1079.6, conf.level=0.95)

#########################################################################

                                                          # Section 6.7.4                                                     
  
age <- c("0-19","20-44","45-64","65 and older")    # age groups
d.i <- c(   34,   135,   299,  1167)               # deaths
n.i <- c(34000, 75500, 27000, 15000)               # population
sum(d.i)/sum(n.i)                                  # raw rate           
s.i  <- c( 0.18,  0.40,  0.25,  0.17)              # reference population
N    <- 1000000
N.i  <- N*s.i
rate <- sum(d.i * (s.i/n.i)); rate                 # age standardized   
var  <- sum(d.i *(s.i/n.i)^2); var                 # variance estimate    
maxwt  <- max(s.i/n.i)                             # maximum weight

r.i   <- c(0.0005, 0.002, 0.008, 0.065)
e.i   <- r.i * n.i; sum(e.i)
cbind(age, N.i, n.i, d.i, r.i, e.i)                # example data table

alpha <- 0.05
dfl    <- (2*rate^2)/var
lowlim <- (var/(2*rate)) * qchisq(alpha/2, dfl)

dfu    <- 2*(rate+maxwt)^2/(var+maxwt^2)
upplim <- (var + maxwt^2)/(2*(rate + maxwt)) * qchisq(1-alpha/2, dfu)
lowlim; upplim


#########################################################################

                                           
alpha <- 0.05; z <- qnorm(1-alpha/2)       # standardized mortality ratio
r.i   <- c(0.0005, 0.002, 0.008, 0.065)
e.i   <- r.i * n.i; sum(e.i)
O     <- sum(d.i); E <- sum(e.i) 
SMR   <- (O/E)*100; SMR
lowlim <- ((O/E)*100)   * (1 - 1/(9*O)     - z/(3*sqrt(O)))^3 
upplim <- ((O+1)/E)*100 * (1 - 1/(9*(O+1)) + z/(3*sqrt(O+1)))^3 
lowlim; upplim

#########################################################################

                             # SMR/RR : power and minimal detectable risk
rpwr.risk <- function(E, R=NULL, alpha=0.05, power=NULL) {
  beta <- 1 - power
  if ((is.null(power) & is.null(R)))  stop                       
  if(is.null(power)) power <- pnorm(2*sqrt(E)*(sqrt(R)-1) - qnorm(1-alpha))
  if(is.null(R))  R <- (1 + (qnorm(1-alpha)+qnorm(1-beta))/(2*sqrt(E)))^2
  cat("Expected number :", E,"\n",
      "Signif. level  :", alpha,"\n",
      "Power          :", round(power, 4), "\n", 
      "Rel. Risk      :", round(R,4), "\n")
}
rpwr.risk(E=c(1,5,10,15,20,25,30), power=0.80)

#########################################################################

                                                            # Section 6.8
                                                        
                     # CI for the expected value of a normal distribution
x <- c(95,  84, 105,  96,  86,  86,  95,  94,  75,  93)
n <- length(x)
m <- mean(x); m
s <- sd(x); s
m - qt(0.975, n-1)*s/sqrt(n)                    # lower confidence limit
m + qt(0.975, n-1)*s/sqrt(n)                    # upper confidence limit 

t.test(x, mu = 90, conf.level = 0.95)

#########################################################################
                                                         
                                                          # Section 6.8.4
                                                         
                                 # expected value from paired differences
x <- c(4.0, 3.5, 4.1, 5.5, 4.6, 6.0, 5.1, 4.3)
y <- c(3.0, 3.0, 3.8, 2.1, 4.9, 5.3, 3.1, 2.7)
d <- x - y; d
t.test(x, y, mu=0, paired=TRUE, con.level = 0.95)


#########################################################################

                                                          # Section 6.8.7
                                                         
                  # CI for the expected value of a lognormal distribution
                                
                                                # example carbon monoxyd
x.CO <- c(12.5, 20, 4, 20, 25, 170, 15, 20, 15)
n <- length(x.CO);  y.CO <- log(x.CO)
x.mean <- mean(x.CO); x.stdv <- sd(x.CO); x.med <- median(x.CO)
print(paste("CO-Wert (X)",x.mean, x.med, x.stdv))
y.mean <- mean(y.CO); y.stdv <- sd(y.CO); y.med <- median(y.CO)
print(paste("Y=log(X)   ",y.mean, y.med, y.stdv))
                                                   # naive estimation      
lower_naive <- round(exp(y.mean - qt(0.975, (n-1)) * y.stdv/sqrt(n)), 2)
upper_naive <- round(exp(y.mean + qt(0.975, (n-1)) * y.stdv/sqrt(n)), 2)
print(paste(lower_naive,"<=", round(exp(y.mean), 2),"<=", upper_naive))
                                                   # estimation after Cox    
m         <- y.mean + y.stdv^2/2
v         <- y.stdv^2/n + y.stdv^4/(2*(n-1))                          
lower_cox <- round(exp(m - qt(0.975, (n-1)) * sqrt(v)), 2)
upper_cox <- round(exp(m + qt(0.975, (n-1)) * sqrt(v)), 2)
print(paste(lower_cox,"<=", round(exp(m), 2),"<=",  upper_cox))

#########################################################################

                                                            # Section 6.9

                                    #  CI for the mean absolute deviation
x     <- c(10, 15, 20, 16, 13, 12, 15, 21, 11, 24, 17, 14, 12, 10, 30)
n     <- length(x)
medi  <- median(x)
c     <- n / (n-1)
tau.h <- sum(abs(x-medi))/n; tau.h*c
d     <- (mean(x) - medi)/tau.h;  g   <- var(x) / tau.h^2
varln.tau <- (d^2 + g -1)/n
upper <- exp(log(tau.h*c) + qnorm(0.975)*sqrt(varln.tau)); upper
lower <- exp(log(tau.h*c) - qnorm(0.975)*sqrt(varln.tau)); lower
      
#########################################################################

                                                         #   Section 6.10
                                                           
                                                      # CI for the median 

                                                             
alpha <- 0.05; z     <- qnorm(1-alpha/2)                     # table 6.10
n <- 5 : 104
nl <- length(n)

hu <- round(n/2 - z*sqrt(n)/2)
ho <- round(1 + n/2 + z*sqrt(n)/2)
tab <- cbind(n, hu, ho); tab

tabout <- cbind(tab[1:20,], tab[21:40,], tab[41:60,], tab[61:80,], 
                tab[81:100,])

#library(xtable)
#xtable(tabout, digits=0)

#########################################################################

                                                                
ci_median <- function(x, alpha=0.05) {                # CI for the median
  z <- qnorm(1-alpha/2);   n <- length(x)
  xmed <- median(x, na.rm = TRUE)
  hu <- round(n/2 - z*sqrt(n)/2); ho <- round(1 + n/2 + z*sqrt(n)/2)
  lu <- sort(x)[hu];              lo <- sort(x)[ho]
  cat("\n",(1-alpha)*100,"%-Confidence interval",
      "for the median",xmed,":"," (",lu,", ",lo,")","\n")
}
data <- c(12, 14, 10, 20, 9, 15, 22, 18, 26, 13, 27, 8, 10)
ci_median(data)

#########################################################################
                                       
                                                  # example energy supply      
y1 <- c(15.9,13.6,1.9,1.1,13.8,23.0,28.6,15.0,10.5,
                    12.0,11.8,9.9,74.9,NA,NA)
y2 <- c(3.1, 5.2, 6.3,7.7,9.9,13.1,15.3,16.8,22.2,
                    22.3,23.3,25.9,41.4,51.8,85.2)
name  <- c("Schenectady N.R.","Savannah River","DOE Headquarters",
           "Grand Junction","Albuquerque","Oak Ridge","San Francisco",
           "Energy Tech Centers","Richland","Pittsburg N.R.",
           "Chicago","Idaho","Nevada","Power Admin.",
           "Petroleum Resources")
ausfall <- cbind(y1, y2); 
colnames(ausfall) <- c("1976","1980"); rownames(ausfall) <- name    
bwp <- boxplot(y1, y2, notch=TRUE, names=c("1976","1980"),
       pars = list(boxwex =0.5, staplewex=0.5, outwex=0.5), plot=FALSE)
t1  <- bwp$stats; colnames(t1) <- c("1976","1980")
rownames(t1) <- c("whisker low","1. quartil",
                  "median value","3. quartil","whisker high")   
t2 <- bwp$conf; colnames(t1) <- c("1976","1980")
rownames(t2) <- c("95%-KI lower","95%-KI upper")
tab <- rbind(t1, t2); tab 

                                                             # figure 6.8
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
boxplot(y1, y2, notch=TRUE, names=c("1976","1980"), las=1,
       pars = list(boxwex =0.4, staplewex=0.4, outwex=0.4),
       ylim=c(0,100), col="lightgrey")
text(1.28, 74.9, "Nevada          ")
text(1.29, 28.6, "San Francisco   ")
text(1.29, 4,    "DOE Headquarters")
text(1.28, 0.5,  "Grand Junction  ")  
text(2.28, 85.2, "Petroleum Res.  ")
text(2.28, 51.8, "Power Admin.    ")
points(1, 74.9, pch=20, cex=2)
points(2, 85.2, pch=20, cex=2)

#########################################################################

x <- c(95,  84, 105,  96,  86,  86,  95,  94,  75,  93)
wilcox.test(x, mu = 0, conf.int = TRUE, conf.level = 0.95)

#########################################################################

                                                         # Section 6.10.1

                               # CI for the difference / ratio of medians

mediconfi <- function(x, y, alpha=0.05) {
    zalpha <- qnorm(1-alpha/2)
    x  <- sort(x);                      y <- sort(y)
    nx <- length(x); 				   ny <- length(y)
    xmed <- median(x);  			 ymed <- median(y)
    cx <- round((nx +1)/2 - sqrt(nx)); cy <- round((ny +1)/2 - sqrt(ny))
    px <- 0;                           py <- 0
    for (i in 0:(cx-1)) px <- px + choose(nx, i) * 0.5^(nx)
    for (i in 0:(cy-1)) py <- py + choose(ny, i) * 0.5^(ny)
    zx <- qnorm(1-px); zy <- qnorm(1-py)
    varxmed  <- ((x[nx-cx+1]-x[cx])/(2*zx))^2
    varymed  <- ((y[ny-cy+1]-y[cy])/(2*zy))^2
    varxmeds <- ((log(x[nx-cx+1])-log(x[cx]))/(2*zx))^2
    varymeds <- ((log(y[ny-cy+1])-log(y[cy]))/(2*zy))^2
    medidiff <- round(xmed - ymed, 3)
    mediquot <- round(xmed / ymed, 3)
    lmeddiff <- round(medidiff - zalpha * sqrt(varxmed + varymed), 3)
    umeddiff <- round(medidiff + zalpha * sqrt(varxmed + varymed), 3)
    lmedquot <- round(exp(log(xmed/ymed)-zalpha*(sqrt(varxmeds) + varymeds)), 3)
    umedquot <- round(exp(log(xmed/ymed)+zalpha*(sqrt(varxmeds) + varymeds)), 3)
    cat("\n",(1-alpha)*100,"%-Confidence interval","\n", 
        "for the diference",xmed,"-",ymed,": = ",medidiff,
        " (",lmeddiff,", ",umeddiff,")","\n",
        "for the ratio",xmed,"/",ymed,": = ",mediquot,
        " (",lmedquot,", ",umedquot,")","\n")
}

#########################################################################

sunny <- c(4.1, 4.5, 4.8, 5.1, 5.1, 5.3, 5.5, 6.0)
skady <- c(5.5, 5.5, 5.5, 5.9, 6.3, 6.5, 6.8, 7.2)
quantile(sunny); quantile(skady)	
mediconfi(sunny, skady, alpha=0.05)

#########################################################################

wilcox.test(sunny, skady, alternative = "two.sided", 
			correct = TRUE, conf.int = TRUE)

#########################################################################

                                                         # Section 6.10.2
                                                         
ci.perc <- function(data, p, level) {                  # CI for quantiles
  n <- length(data);  plev <- 0
  upper <- ceiling((n+1)*p);   lower <- floor((n+1)*p)
  while(plev < level) { upper<-upper+1; lower<-lower-1
      plev <- pbinom(upper-1, size=n, prob=p) 
                      - pbinom(lower-1, size=n, prob=p) }
  x <- sort(data)
cat(100*level,"%-CI for the",p,"-quantil from the data:",
          x[lower],"-",x[upper],"\n")
}

daten <- c(95, 84, 105, 96, 86, 95, 94, 75, 93)
ci.perc(daten, 0.5, 0.95)

#########################################################################

library(Hmisc)
quantile(daten)
hdquantile(daten, se=TRUE)        # Harrell-Davis estimator for quantiles

#########################################################################

hd<-function(x, q=.5){            # Harrell-Davis estimator for quantiles
    if(length(x)!=length(x[!is.na(x)])) stop("Remove missing values from x")
    n   <- length(x)
    m1  <- (n+1)*q
    m2  <- (n+1)*(1-q)
    vec <- seq(along=x)
    w   <- pbeta(vec/n, m1, m2) - pbeta((vec-1)/n, m1, m2)
    y   <- sort(x)
    sum(w*y)
}
hd(daten, q=0.25)

#########################################################################

                                                         # Section 6.10.3

                                                # CI for reference values

alpha <- 0.05              # 95% reference range - coverage (q)
beta  <- 0.10              # 90% - CI
za  <- qnorm(1-alpha/2)    # two sided
phi <- dnorm(za)
zb  <- qnorm(1-beta/2)

const <- zb*sqrt((2+za^2)/2); const                         # see Solberg
                                                            
delta <- c(0.040, 0.030, 0.025, 0.020, 0.015, 0.01)         # table 6.12
par    <- round((1 + 0.5*za^2)*(phi*zb/(delta/2))^2, 0)
nonpar <- round(alpha/2 * (1-alpha/2) * (zb/(delta/2))^2, 0) 
cbind(delta, par, nonpar)

##########################################################################

nreference <- function(alpha=0.05, side="two-sided", beta=0.10, delta=0.01) {
  if (side=="one-sided") {
    za <- qnorm(1-alpha); phi <- dnorm(za); zb <- qnorm(1-beta/2);
    par    <- round((1 + 0.5*za^2)*(phi*zb/delta)^2, 0)
    nonpar <- round(alpha * (1-alpha) * (zb/delta)^2, 0)  }
  if (side=="two-sided") {
    delta <- delta/2
    za <- qnorm(1-alpha/2); phi <- dnorm(za); zb <- qnorm(1-beta/2);
    par    <- round((1 + 0.5*za^2)*(phi*zb/delta)^2, 0)
    nonpar <- round(alpha/2 * (1-alpha/2) * (zb/delta)^2, 0)  }
  pa  <- (1-alpha)*100;   pb  <- (1-beta)*100
  cat("\n","Sample size estimation for the",pa,"\b%-Reference range",side,"\n",
      "with a", pb,"\b%-CI and a tolerance of", round(delta*100, 1), "\b% \n",
      "n - parametric      =", par, "\n","n - nonparametric   =", nonpar,"\n")
} 
nreference(alpha=0.05, side="one-sided", beta=0.10, delta=0.01)

nreference(alpha=0.05, side="two-sided", beta=0.10, delta=0.01)

#########################################################################

                                                           # Section 6.11
                                                           
                                              # CI using bootstrap method
x <- c(68, 69, 69, 70, 71, 72, 72, 74); mean(x)
b1 <- sample(x, 8, replace = TRUE); b1; mean(b1)
b2 <- sample(x, 8, replace = TRUE); b2; mean(b2)
b3 <- sample(x, 8, replace = TRUE); b3; mean(b3)
b4 <- sample(x, 8, replace = TRUE); b4; mean(b4)
b5 <- sample(x, 8, replace = TRUE); b5; mean(b5)
sd(c(mean(b1), mean(b2), mean(b3), mean(b4), mean(b5)))

##########################################################################

x <- c(68, 69, 69, 70, 71, 72, 72, 74)
b <- rep(NA, 1000)
for (i in 1:1000) b[i] <- mean(sample(x, 8, replace=TRUE))
quantile(b, probs = c(0.025, 0.975))

##########################################################################

library(bootstrap)                          # bootstrap perzentile method
x <- c(10, 10, 11, 12, 12, 13, 14, 15, 15, 16, 17, 20, 21, 24, 30)
n <- length(x)
boot <- bootstrap(x, 500, median)            # median from 500 samples 
quantile(boot$thetastar, probs=c(.025,.975)) # quantile from distribution 

##########################################################################

                                             
library(bootstrap)                                   # bootstrap t-method
x <- c(10, 15, 20, 16, 13, 12, 15, 21, 11, 24, 17, 14, 12, 10, 30)
boott(x, median, nbootsd=50, nboott=1000, perc=c(0.025, 0.975))

##########################################################################
                                             
mean(x)+qt(0.025, n-1)*sd(x)/sqrt(n)              # analytically approach
mean(x)+qt(0.975, n-1)*sd(x)/sqrt(n) 

#########################################################################

                                                           # Section 6.12

                                                        # CI the variance

                                             # sample size after Guenther
                                             # see also table 6.15
sL.limit <- function(n, alpha, gamma) {
  chiq1 <- sqrt(qchisq(gamma, n-1))
  chiq2 <- sqrt(qchisq(alpha/2,n-1))
  chiq3 <- sqrt(qchisq(1-alpha/2, n-1))
  L <- chiq1*(1/chiq2 - 1/chiq3)  
}

val <- sL.limit(c(75,  12,  6), 0.10, 0.90); round(val,1)
val <- sL.limit(c(88,  15,  7), 0.10, 0.99); round(val,1)
val <- sL.limit(c(105, 16,  7), 0.05, 0.90); round(val,1)
val <- sL.limit(c(120, 19,  9), 0.05, 0.99); round(val,1)


mL.limit <- function(n, alpha, gamma) {
  t.q   <- qt(1-alpha/2, n-1)
  chi.q <- qchisq(gamma, n-1)
  L     <- sqrt((4*t.q^2*chi.q)/(n*(n-1)))
}

val <- mL.limit(c(140, 18,  7), 0.10, 0.90); round(val,1)
val <- mL.limit(c(150, 22,  9), 0.10, 0.99); round(val,1)
val <- mL.limit(c(190, 24,  9), 0.05, 0.90); round(val,1)
val <- mL.limit(c(210, 29, 11), 0.05, 0.99); round(val,1)

#########################################################################

                                                         # Section 6.12.1

                                    # CI for the coefficient of variation

cv_ki <- function(x, conf.level=0.95) {
  alpha <- 1 - conf.level
  n <- length(x)
  V <- sd(x)/mean(x)
  q1 <- qchisq(1-alpha/2, df=n-1);  q2 <- qchisq(alpha/2, df=n-1)
  low <- round(V / sqrt((q1/(n-1)+V^2*((q1+2)/n - 1))), 4)
  upp <- round(V / sqrt((q2/(n-1)+V^2*((q2+2)/n - 1))), 4)
  cat("\n","Coefficient of variation V=","\b",round(V, 4),"\n",
      100*conf.level,"\b%-Confidence interval:",low,"to",upp,"\n")
}

x <- c(9.74,  9.44, 10.30,  9.39,  9.72,  9.78, 10.46,  8.98, 10.77,  9.84,
       8.77, 10.40, 10.69, 10.16, 10.36,  9.69, 10.33,  9.92,  9.82,  9.43)
cv_ki(x, conf.level=0.95)

#########################################################################

                                                     # table 6.16 (?)

library(MBESS)                                       # function ss.aipe()
width <- seq(0.02, 0.10, 0.01)
n <- length(width)
size3  <- rep(NA, n)
size5  <- rep(NA, n)
size7  <- rep(NA, n)
size10 <- rep(NA, n)

for (i in 1:n) {
  size3[i]  <- ss.aipe.cv(C.of.V = 0.03, width = width[i], conf.level = 0.95)
  size5[i]  <- ss.aipe.cv(C.of.V = 0.05, width = width[i], conf.level = 0.95)
  size7[i]  <- ss.aipe.cv(C.of.V = 0.07, width = width[i], conf.level = 0.95)
  size10[i] <- ss.aipe.cv(C.of.V = 0.10, width = width[i], conf.level = 0.95)
}

tab1 <- rbind(width*100, "3%"=ceiling(size3), "5%"=ceiling(size5), 
              "7%"=ceiling(size7), "10%"=ceiling(size10))

############################################################################

width <- seq(0.02, 0.10, 0.01)
n <- length(width)
size3  <- rep(NA, n)
size5  <- rep(NA, n)
size7  <- rep(NA, n)
size10 <- rep(NA, n)

for (i in 1:n) {
  size3[i]  <- ss.aipe.cv(C.of.V = 0.03, width = width[i], conf.level = 0.99)
  size5[i]  <- ss.aipe.cv(C.of.V = 0.05, width = width[i], conf.level = 0.99)
  size7[i]  <- ss.aipe.cv(C.of.V = 0.07, width = width[i], conf.level = 0.99)
  size10[i] <- ss.aipe.cv(C.of.V = 0.10, width = width[i], conf.level = 0.99)
}

tab2 <- rbind(width*100, "3%"=ceiling(size3), "5%"=ceiling(size5), 
              "7%"=ceiling(size7), "10%"=ceiling(size10))

tab <- rbind(tab1, tab2); tab

# ss.aipe.cv(C.of.V = 0.05, width = 0.03, conf.level = 0.95)

#########################################################################

                                                           # Section 6.13

                                                   # Weibull distribution   
                                      
                                                # example quality of yarn          
yarn  <- c(550, 760, 830, 890, 1100, 1150, 1200, 1350, 1400, 1600, 
           1700, 1750, 1800, 1850, 1850, 2200, 2400, 2850, 3200)
yarn <- sort(yarn);  n    <- length(yarn)
F    <- (rank(yarn) - 0.3) / (n+0.4)             # empirical distribution   
x    <- log(yarn)                                # transformation                   
y    <- log(log(1/(1-F)))
z <- lm(y ~ x); z                                # linear regression               
coef(z)[2]                                       # shape                            
exp(-(coef(z)[1]/coef(z)[2]))                    # scale    

#########################################################################
                                                
library(bbmle)                                 # MLE Weibull distribution 
ll <- function(shape=1.5, scale=2000) 
        - sum(stats::dweibull(yarn, shape, scale, log = TRUE))
mle2(ll)

#########################################################################

                                                             # figure 6.9                    
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=18)
plot(x, y, xlab="x=log(yarn)", ylab="y=log(log(1/(1-F)))", las=1, 
     xlim=c(6,8.5), ylim=c(-4, 2), pch=16, cex=1.3)
abline(z)
i <- rank(yarn);  n <-length(yarn)
v.unten <- 1 / (((n-i+1)/i)*(qf(0.025, 2*(n-i+1), 2*i))+1)
v.oben  <- 1 - 1 / (1 + (i / (n-i+1)*qf(0.025, 2*i, 2*(n-i+1))))
lines(x, log(log(1/(1-v.oben))), lty=2)
lines(x, log(log(1/(1-v.unten))), lty=2)

#########################################################################

                                                           # Section 6.14

                                               # CI for linear regression
n   <- 7
x   <- c(13, 17, 10, 17, 20, 11, 15); sum(x); sum(x^2)
y   <- c(12, 17, 11, 13, 16, 14, 15); sum(y); sum(y^2)
xy  <- x * y;                         sum(xy)
Qx  <- sum(x^2) - sum(x)^2/n;         Qx
Qy  <- sum(y^2) - sum(y)^2/n;         Qy
Qxy <- sum(xy)  - sum(x)*sum(y)/n;    Qxy

r   <- Qxy / sqrt(Qx*Qy);             r 

sx   <- sqrt(Qx/(n-1));               sx
sy   <- sqrt(Qy/(n-1));               sy
sy.x <- sqrt((Qy - Qxy^2/Qx)/(n-2));  sy.x 

byx  <- Qxy/Qx;                        byx
sbyx <- sy.x/sqrt(Qx);                 sbyx

ayx  <- mean(y) - byx*mean(x);         ayx
sayx <- sy.x*sqrt(1/n + mean(x)^2/Qx); sayx

#########################################################################

summary(lm(y~x))

#########################################################################

                                                         # Section 6.14.3
                                                                                
new <- data.frame(x = c(12,14,16,18))        # prediction in linear model
predict(lm(y~x), new, int="c", level = 0.95)

#########################################################################

predict(lm(y~x), new, int="p", level = 0.95) # prediction in linear model

#########################################################################

                                          # example wing span of sparrows
age     <- c(  3,  4,  5,  6,  8,  9, 10, 11, 12, 14, 15, 16, 17) # days 
wings   <- c(1.4,1.5,2.2,2.4,3.1,3.2,3.2,3.9,4.1,4.7,4.5,5.2,5.0) # cm   
labx <- "Age [days]"; laby <- "Wing span [cm]"

mod <- lm(wings ~ age)                          # linear model in R
summary(mod)
a <- mod$coef[1]; round(a, 2)                   # intercept
b <- mod$coef[2]; round(b, 3)                   # regression coefficient

########################################################################

                                                           # figure 6.11 
par(mfrow=c(1,2), lwd=2, font=2, font.axis=2, bty="l", ps=14)
plot (age, wings, type="p", las=1,  
      xlab=labx, ylab=laby, cex=1.5, pch=16, col = "blue") 
text(8, 5, "95% Confidence interval", cex=1.2)
chol.est <- a + b * age
lines(age, chol.est, lty=1.2, col="black")
                                             
newx  <- seq(3, 17, by=1)                           # confidence interval              
conf_band <- predict(mod, newdata=data.frame(age=newx), 
                     interval="confidence", level = 0.95)
lines(newx, conf_band[,2], col="red", lty=2, lwd=3)
lines(newx, conf_band[,3], col="red", lty=2, lwd=3)

plot (age, wings, type="p", las=1,
      xlab=labx, ylab=laby, cex=1.5, pch=16, col = "blue")
text(8, 5, "95% Prediction interval", cex=1.2)
chol.est <- a + b * age
lines(age, chol.est, lty=1.2, col="black")
                                                    # prediction interval
conf_band <- predict(mod, newdata=data.frame(age=newx), 
                     interval="prediction", level = 0.95)
lines(newx, conf_band[,2], col="red", lty=4, lwd=3)
lines(newx, conf_band[,3], col="red", lty=4, lwd=3)

#########################################################################

                                                           # Section 6.15

                                     # CI for the correlation coefficient
                   
n <- 50                                           # Fisher transformation
r <- 0.687
zp <- 0.5*log((1+r)/(1-r)); zp
szp <- 1/sqrt(n-3)
lwr.z <- zp - qnorm(0.975)*szp; upr.z <- zp + qnorm(0.975)*szp
lwr.z; upr.z
lwr.r <- (exp(2*lwr.z)-1)/(exp(2*lwr.z)+1)
upr.r <- (exp(2*upr.z)-1)/(exp(2*upr.z)+1)
lwr.r; upr.r

#########################################################################

                                             # sample size for estimation
z.trans <-  function(r) 0.5*log((1+r)/(1-r))
r.u = 0.50; r.o <- 0.80; alpha <- 0.05
n <- 4*(qnorm(1-alpha/2)/(z.trans(r.o)-z.trans(r.u)))^2 + 3
ceiling(n)

#########################################################################

                                                           # Section 6.16

                                                  # agreement / precision
x  <- seq(0, 10, by=0.2); n <- length(x)
y  <- x
y1 <- x+3;         y1v <- y1 + rnorm(n, 0, 0.7)
y2 <- 3*x;         y2v <- y2 + rnorm(n, 0, 1)
y3 <- 0.25*x + 4;  y3v <- y3 + rnorm(n, 0, 0.5)
                                                            # figure 6.13
par(mfrow=c(1,3), lwd=2, font.axis=2, bty="n", ps=16)
plot(x, y1, xlab="x", ylab="y", main="Location shift", las=1,
		type="l", xlim=c(0,10), ylim=c(0,10))
points(x, y1v, col="darkgrey", cex=1.5); abline(0, 1, lty=3)
plot(x, y2, xlab="x", ylab="y", main="Ratio shift", las=1,
		type="l", xlim=c(0,10), ylim=c(0,10))
points(x, y2v, col="darkgrey", cex=1.5); abline(0, 1, lty=3)
plot(x, y3, xlab="x", ylab="y", las=1,
     main="Location and ratio shift",
		type="l", xlim=c(0,10), ylim=c(0,10))
points(x, y3v, col="darkgrey", cex=1.5); abline(0, 1, lty=3)

#########################################################################

                                                         # Section 6.16.1

                                        # reliability - Bland-Altman plot

x1 <- c(16.6, 17.8,  6.9,  7.6,  7.8,  7.4, 11.2, 16.1, 14.6,  5.0, 18.8, 
        10.5,  8.1, 15.4,  7.2, 12.2,  1.9, 15.6, 14.9,  8.3)
x2 <- c(18.8, 17.4,  5.4, 11.7,  7.6,  5.4, 10.3, 15.0, 12.1,  2.9, 16.4,
        10.2,  3.2, 15.9,  5.0, 10.3,  1.0, 15.4, 14.9, 10.5)
cor(x1, x2)                                        
diff   <-  x1 - x2;     mittel <- (x1 + x2)/2
mdiff  <- mean(diff); mdiff
sdiff  <- sd(diff);   sdiff
upplim   <- mdiff + 2*sdiff; upplim   
lowlim   <- mdiff - 2*sdiff; lowlim
n        <- length(diff)
tval     <- qt(0.025, n-1, lower.tail=F)           
upp95    <- mdiff + tval * sqrt(sdiff^2/n); upp95
low95    <- mdiff - tval * sqrt(sdiff^2/n); low95
upp95u  <- upplim + tval * sqrt(sdiff^2/n); upp95u
upp95l  <- upplim - tval * sqrt(sdiff^2/n); upp95l
low95u  <- lowlim + tval * sqrt(sdiff^2/n); low95u
low95l  <- lowlim - tval * sqrt(sdiff^2/n); low95l

#########################################################################

                                                            # figure 6.14
par(lwd=2, font.axis=2, bty="l", ps=14, mfrow=c(1,2))
plot(x1, x2, xlim=c(0,20), ylim=c(0,20), cex=1.0, las=1,
     xlab="1st measurement", ylab="2nd measurement")                  
abline(0,1,col="black")
plot(mittel, diff, xlim=c(0,20), cex=1.0,
     ylim=c(-6, +6),xlab="Mean", ylab="Difference")
abline(h=mdiff,  col="black", lty=2)
abline(h=upplim, col="black", lty=2); abline(h=lowlim, col="black", lty=2)
abline(h=upp95u, col="black", lty=3); abline(h=upp95l, col="black", lty=3)
abline(h=low95u, col="black", lty=3); abline(h=low95l, col="black", lty=3) 

#########################################################################

                                                            # sample size
                                                    
                                                            # figure 6.15

                                        # LOAs from: D plus/minus 1.96*SD
n  <- 10:100; CI <- 1.96*sqrt(3/n)      # 95%-KI: +/-1.96*sqrt(3/n)*SD            

par(mfrow=c(1,1), lwd=2, font.axis=2, bty="l", ps=14)
plot(n, CI, type="l", xlab="Sample size n",
     ylab="Width of 95%-CI [+/-SD%]", las=1)
abline(h=seq(0.4,1.0,0.1), lty=2, col="grey")
abline(v=50, col="red")
abline(h=0.48, col="red")


#########################################################################

                                                         # Section 6.16.2

                                                   # example data arsenic
x <- c(8.71, 3.28, 5.60, 1.55, 1.75, 0.73, 3.66, 0.90, 9.39, 4.39, 
       3.69, 0.34, 1.94, 2.07, 1.38, 1.81, 0.82, 1.88,10.66,19.25)
y <- c(7.35, 3.40, 5.44, 2.07, 2.29, 0.66, 3.43, 1.25, 6.58, 3.31,
       2.72, 2.32, 1.50, 3.50, 1.17, 2.31, 0.44, 1.37,12.53,15.86)
fitx <- lsfit(y, x); fitx$coefficients               # lineare Regression
fity <- lsfit(x, y); fity$coefficients

#########################################################################

rho <- 1                                              # Deming Regression                                          
mx  <- mean(x); my <- mean(y)
vx  <- var(x);  vy <- var(y); vxy <- cov(x,y)
b1.deming <- ((rho*vy - vx) + sqrt((vx - rho*vy)^2 + 
              4*rho*vxy^2))/(2*rho*vxy); b1.deming
b0.deming <- my - b1.deming*mx; b0.deming

#########################################################################

library(mcr)                          # Deming Regression in library(mcr)
fit <- mcreg(x, y, error.ratio=rho, method.reg="Deming")
printSummary(fit)

par(mfrow=c(1,1), lwd=1.5, font.axis=2, bty="l", ps=11, cex.axis=1.1)
plot(fit)
                                                
di   <- y - (b0.deming + b1.deming*x)             # estimates for x and y
xhat <- x + (rho*b1.deming*di)/(1+rho*b1.deming^2)
yhat <- y - di/(1 + rho*b1.deming^2)
points(xhat, yhat, pch=3, col="red", cex=2)

#########################################################################

                              # correlation coefficient Deming Regression
r   <- cor(x,y); byx <- fity$coefficients[2]
U <- byx/(2*r^2) - (1/rho)/(2*byx)
b1.short <- U + sqrt(U^2 + 1/rho); b1.short
b1.short <- byx/r; b1.short                            # simple for rho=1

#########################################################################

                                              # Passing-Bablok Regression
n <- length(x);   s <- array(NA, dim=c(n,n))
for(i in 1:(n-1)) {                           # combining all pairwise
  for(j in (i+1):n) {
    if(i != j) { s[i,j] <- (y[i] - y[j])/(x[i] - x[j]) }  }  }
s <- sort(na.exclude(as.vector(s)))
K <- sum(s <= -1) - .5 * sum(s == -1); N <- length(s)     # shift median
b1.passing <- ifelse(N%%2,s[(N+1)/2+K],mean(s[N/2+K+0:1])); b1.passing
b0.passing <- median(y - b1.passing*x); b0.passing

#########################################################################

library(mcr)                  # Passing-Bablok Regression in library(mcr)
fit <- mcreg(x, y, method.reg="PaBa") 
printSummary(fit)

par(mfrow=c(1,1), lwd=1.5, font.axis=2, bty="l", ps=11, cex.axis=1.1)
plot(fit)

#########################################################################

                                                            # figure 6.16
fitx <- lsfit(y, x); fitx$coefficients                # linear regression
fity <- lsfit(x, y); fity$coefficients

par(mfrow=c(1,2), lwd=1.5, font.axis=2, bty="l", ps=14, cex.axis=1.1)

plot(x, y, xlab="X - method 1", ylab="Y - method 2", las=1,
     xlim=c(0,20), ylim=c(0,20), main="Deming regression (A)", cex=1.5)
abline(a = 0, b = 1, lty=3)
abline(h=seq(0,20,5), lty=2, col="grey")
abline(v=seq(0,20,5), lty=2, col="grey")
abline(fity, col="blue", lty=2); abline(fitx, col="blue", lty=2)
abline(a = b0.deming, b = b1.deming, col = "red", lty=1, lwd=2)

plot(x, y, xlab="X - method 1", ylab="Y - method 2", las=1,
     xlim=c(0,20), ylim=c(0,20), main="Passing-Bablock regression (B)", cex=1.5)
abline(a = 0, b = 1, lty=3)
abline(h=seq(0,20,5), lty=2, col="grey")
abline(v=seq(0,20,5), lty=2, col="grey")
abline(fity, col="blue", lty=2); abline(fitx, col="blue", lty=2)
abline(a = b0.passing, b = b1.passing, col = "red", lty=1, lwd=2)

#########################################################################

                                                         # Section 6.16.3

x <- c(4.80, 4.75, 4.34, 5.10, 4.47, 4.02, 4.43, 6.45, 5.36, 6.63)
y <- c(4.62, 4.73, 4.84, 4.98, 4.05, 4.35, 4.84, 5.47, 5.02, 5.99)

                                                
bradley.blackwood.test <- function(x, y) {       # Bradley-Blackwood Test
  S <- x + y; mS <- mean(S); sdS <- sd(S)
  D <- x - y; mD <- mean(D); sdD <- sd(D) 
  n <- length(D) 
                          # linear regression - sum of squared deviations
  mod <- lm(D~S);   RSE <- sum(mod$residuals^2)
                          # F statistic after Bradley-Blackwood
  F.stat <- ((sum(D^2) - RSE)/2)/(RSE/(n-2))
  p.val  <- pf(F.stat, 2, n-2, lower.tail=F)
  cat("\n","Series X   - Mean:",round(mean(x),3)," - variance:",round(var(x),4),
      "\n","Series Y   - Mean:",round(mean(y),3)," - variance:",round(var(y),4),
      "\n","Difference - Mean:",round(mean(D),3)," - variance:",round(var(D),4),
      "\n","Bradley-Blackwood test: F=",round(F.stat,3),
      "(p=",round(p.val,4),")","\n")
}
bradley.blackwood.test(x, y)

#########################################################################

                                                         # Section 6.16.4

                   # concordance correlation coefficient according to Lin

lead <- data.frame(matrix(                   # example lead concentration
  c(1,	0.22,	0.21,  2,	0.26,	0.23, 3,	0.30,	0.27,  4,	0.33,	0.27,
    5,	0.36,	0.31,  6,	0.39,	0.33, 7,	0.41,	0.37,  8,	0.44,	0.38,
    9,	0.47,	0.40,  10,	0.51,	0.43,  11, 0.55,  0.47),byrow=T, nrow = 11))
dimnames(lead)[[2]] <- c("sample","X","Y")
attach(lead)
rho.c  <- 2*cov(X,Y) / (var(X) + var(Y) + (mean(X) - mean(Y))^2); rho.c

#########################################################################
                                           
ciconcord <- function(x, y, alpha=0.05) {             # confidence limits
  zquant <- qnorm(1-alpha/2); n  <- length(X)
  r <- cor(X, Y, method = "pearson")
  rho.c  <- 2*cov(X,Y) / (var(X) + var(Y) + (mean(X) - mean(Y))^2)
  zc <- 0.5*log((1+rho.c)/(1-rho.c))
  u <- ((n-1)*(mean(X) - mean(Y))^2) / 
      sqrt(sum((X-mean(X))^2)*sum((Y-mean(Y))^2))
  vzc <- (((1-r^2)*rho.c^2) / ((1-rho.c^2)*r^2) 
          + (4*rho.c^3*(1-rho.c)*u^2) / (r*(1-rho.c^2)^2) 
          - (2*rho.c^4*u^4) / (r^2*(1-rho.c^2)^2)) / (n-2)
  sezc <- sqrt(vzc)/sqrt(n)	
  lwr.zc <- zc - zquant*sezc  
  upr.zc <- zc + zquant*sezc
  lwr.r <- (exp(2*lwr.zc)-1)/(exp(2*lwr.zc)+1)
  upr.r <- (exp(2*upr.zc)-1)/(exp(2*upr.zc)+1)
  cat("\n", (1-alpha)*100,"%-Confidence interval for the concodance","\n",
      "correlation coefficient (", round(rho.c,3),"): [", 
      round(lwr.r,3),";",round(upr.r,3),"]","\n")
}
ciconcord(lead$X, lead$Y)


#########################################################################

                                                         # Section 6.16.5
                                                         
                                    # intra-class correlation coefficient

                                                         # CI for the ICC            

hypo <- as.data.frame(                       # example - pituitary height
        matrix(c(11.70,   12.50,   11.30,  7.10,    7.50,    7.80,
                  9.60,   10.30,    9.60,  7.60,    7.70,    7.40,
                  6.00,    5.90,    5.80,  6.40,    6.70,    6.20,
                  8.30,    8.30,    8.40,  9.60,    9.80,    9.90,
                  3.00,    3.40,    4.40,  5.20,    5.70,    5.40), 
                  nrow = 10, ncol = 3, byrow = TRUE,
                  dimnames = list(1:10, c("U1", "U2", "U3"))))
hypo

#########################################################################

ICC <- function(x, t) {                                             
    n <- dim(x)[1]; k <- dim(x)[2]
    col.sums  <- apply(x, 2, sum);   row.sums  <- apply(x, 1, sum)
    tot.sum   <- sum(col.sums); 
    col2.sums <- apply(x^2, 2, sum); tot2.sum  <- sum(col2.sums)
                                                    # variance components                  
    SSt       <- tot2.sum          - tot.sum^2/(n*k)
    SSa       <- sum(row.sums^2)/k - tot.sum^2/(n*k)
    SSb       <- sum(col.sums^2)/n - tot.sum^2/(n*k)
    SSe       <- SSt - SSa - SSb
                                     # ANOVA according to Shrout - Fleiss
    BMS       <- SSa/(n-1);       WMS       <- (SSt-SSa)/(n*(k-1))
    JMS       <- SSb/(k-1);       EMS       <- SSe/((n-1)*(k-1)) 
    
    if (t==1) { 
        ICC <- (BMS-WMS)/(BMS+(k-1)*WMS)
        Qms <- BMS / WMS
        quf <- qf(0.975, n-1, n*(k-1)); qof <- qf(0.025, n-1, n*(k-1))
        liu <- (Qms - quf)/(Qms + (k-1)*quf)
        lio <- (Qms - qof)/(Qms + (k-1)*qof) }
    if (t==2) {
        ICC <- (BMS-EMS)/(BMS+(k-1)*EMS+(k*JMS-EMS)/n)
        Fj  <- JMS/EMS
        nue <- ((k-1)*(n-1)*(k*ICC*Fj+n*(1+(k-1)*ICC)-k*ICC)^2) /
            ((n-1)*k^2*ICC^2*Fj^2+(n*(1+(k-1)*ICC)-k*ICC)^2)
        quf <- qf(0.975, n-1, nue); qof <- qf(0.975, nue, n-1)
        liu <- (n*(BMS-quf*EMS))/(quf*(k*JMS+(k*n-k-n)*EMS)+n*BMS)
        lio <- (n*(qof*BMS-EMS))/(k*JMS+(k*n-k-n)*EMS+n*qof*BMS) }
    if (t==1 | t==2) {
        cat("ICC Typ(",t,") = ", round(ICC,4), "\n", 
            "95%-Confidence interval: ",
            round(liu,4)," - ",round(lio,4),"\n") }
    else cat("Type unknown","\n")
}
ICC(hypo, 2)

#########################################################################

library(irr)
icc(hypo, "oneway", "agreement")   # spec. funktion icc() in library(irr)

#########################################################################

                                                           # Section 6.17 

                                                       # tolerance limits
tol_int <- function(gamma, n, P=0.95, dir="two-sided") {
  if (dir=="one-sided") 
    k <- qt(gamma, n-1, qnorm(P)*sqrt(n))/sqrt(n)
  if (dir=="two-sided")
    k <- sqrt(((n-1)*(1+1/n)*(qnorm((1-P)/2)^2))/qchisq(1-gamma,n-1))
  cat("The tolerance factor (",dir,") for n =",n,"\n",
      "observations wih Gamma =",gamma,"and P =",P,"is k =",k,"\n") }

tol_int(0.80, n=10, P=0.90, dir="one-sided")

#########################################################################

                                                             # table 6.21
n <- c(seq(5, 50, 5), seq(60, 100, 10)); nl <- length(n)

tabn  <- c("Anzahl n", n)
tab1  <- as.data.frame(matrix(rep(NA, 2*(nl+1)), ncol=2, nrow=nl+1))
tab2  <- as.data.frame(matrix(rep(NA, 2*(nl+1)), ncol=2, nrow=nl+1))
tab3  <- as.data.frame(matrix(rep(NA, 2*(nl+1)), ncol=2, nrow=nl+1))
tab4  <- as.data.frame(matrix(rep(NA, 2*(nl+1)), ncol=2, nrow=nl+1))
tab5  <- as.data.frame(matrix(rep(NA, 2*(nl+1)), ncol=2, nrow=nl+1))
tab6  <- as.data.frame(matrix(rep(NA, 2*(nl+1)), ncol=2, nrow=nl+1))

gamma <- 0.90; p <- 0.95
k1 <- qt(gamma, n-1, qnorm(p)*sqrt(n))/sqrt(n)
k2 <- sqrt(((n-1)*(1+1/n)*(qnorm((1-p)/2)^2))/qchisq(1-gamma,n-1))
tab1[1,1] <- "k einseitig";    tab1[1:nl+1, 1] <- round(k1, 2) 
tab1[1,2] <- "k zweiseitig ";  tab1[1:nl+1, 2] <- round(k2, 2)

gamma <- 0.95; p <- 0.95
k1 <- qt(gamma, n-1, qnorm(p)*sqrt(n))/sqrt(n)
k2 <- sqrt(((n-1)*(1+1/n)*(qnorm((1-p)/2)^2))/qchisq(1-gamma,n-1))
tab2[1,1] <- "k einseitig";    tab2[1:nl+1, 1] <- round(k1, 2) 
tab2[1,2] <- "k zweiseitig ";  tab2[1:nl+1, 2] <- round(k2, 2)

gamma <- 0.99; p <- 0.95
k1 <- qt(gamma, n-1, qnorm(p)*sqrt(n))/sqrt(n)
k2 <- sqrt(((n-1)*(1+1/n)*(qnorm((1-p)/2)^2))/qchisq(1-gamma,n-1))
tab3[1,1] <- "k einseitig";    tab3[1:nl+1, 1] <- round(k1, 2) 
tab3[1,2] <- "k zweiseitig ";  tab3[1:nl+1, 2] <- round(k2, 2)

gamma <- 0.90; p <- 0.99
k1 <- qt(gamma, n-1, qnorm(p)*sqrt(n))/sqrt(n)
k2 <- sqrt(((n-1)*(1+1/n)*(qnorm((1-p)/2)^2))/qchisq(1-gamma,n-1))
tab4[1,1] <- "k einseitig";    tab4[1:nl+1, 1] <- round(k1, 2) 
tab4[1,2] <- "k zweiseitig ";  tab4[1:nl+1, 2] <- round(k2, 2)

gamma <- 0.95; p <- 0.99
k1 <- qt(gamma, n-1, qnorm(p)*sqrt(n))/sqrt(n)
k2 <- sqrt(((n-1)*(1+1/n)*(qnorm((1-p)/2)^2))/qchisq(1-gamma,n-1))
tab5[1,1] <- "k einseitig";    tab5[1:nl+1, 1] <- round(k1, 2) 
tab5[1,2] <- "k zweiseitig ";  tab5[1:nl+1, 2] <- round(k2, 2)

gamma <- 0.99; p <- 0.99
k1 <- qt(gamma, n-1, qnorm(p)*sqrt(n))/sqrt(n)
k2 <- sqrt(((n-1)*(1+1/n)*(qnorm((1-p)/2)^2))/qchisq(1-gamma,n-1))
tab6[1,1] <- "k einseitig";    tab6[1:nl+1, 1] <- round(k1, 2) 
tab6[1,2] <- "k zweiseitig ";  tab6[1:nl+1, 2] <- round(k2, 2)

tab <- cbind(tabn, tab1, tab2, tab3, tab4, tab5, tab6); tab

#########################################################################

                                                           # Section 6.18 

                                                   # prediction intervals
n <- 5; xbar <- 50.10; stdabw <- 1.31; m <- 3
xbar - qt(0.975, n-1)*stdabw*sqrt(1/m+1/n) 
xbar + qt(0.975, n-1)*stdabw*sqrt(1/m+1/n)

#########################################################################

                                                           # Section 6.19 
                                                        
                                                # Bayes estimation

                                                # example long sleeper                                                             
p     <- seq(0.05, 0.95, by=0.1)                # diskrete a-priori distr.   
prior <- c (5, 15, 30, 30, 5, 5, 4, 2, 2, 2);   nl <- length(prior)
prior <- prior/sum(prior)
success <- 12; failure <- 18             # Sample                  
n       <- success + failure;   p_hat   <- success / n 
Likel   <- rep(NA, nl)                   # Likelihood                    
for (i in 0:nl) Likel[i] <- choose(n, success)*p[i]**success * 
            (1-p[i])**(n-success) 
posterior <- (Likel * prior) / sum(Likel*prior) # posterior distribution

#########################################################################

                                                            # figure 6.17
par(mfrow=c(1,3), lwd=2, bty="n", font.axis=2, font.lab=1, ps=18) 
plot(p, prior, type="h", main="a-priori probability", 
     xlab=" ",ylab=?" ", ylim=c(0, 0.30), xlim=c(0, 1), las=1)
plot(p, Likel, type="h", main="Likelihood", 
     xlab=" ", ylab=" ", ylim=c(0, 0.15), xlim=c(0, 1), las=1)
plot(p, posterior, type="h", main="a-posterior probability", 
     xlab=" ", ylab=" ", ylim=c(0, 0.7), xlim=c(0, 1), las=1)
                   
                                                  # table for figure 6.17      
tab <- cbind(p, prior, round(Likel, 4), round(posterior, 4)); tab

#########################################################################
                                           
obs <- c(0.20, 0.25, 0.30, 0.35, 0.40)        # a-priori knowledge (?)     
m <- mean(obs); m;  s <- sd(obs); s           # beta distribution (prior) 
p.0 <- m * (m*(1-m)/s^2 - 1); p.0
q.0 <- (1-m) * (m*(1-m)/s^2 -1); q.0
prob    <- seq(0, 1, by=0.01)
prior     <- dbeta(prob, p.0, q.0)             # a-prior density          
n <- 30; x <- 12                               # observation (sample)
p.1 <- p.0 + x; p.1; q.1 <- q.0 +n - x; q.1
posterior <- dbeta(prob, p.1, q.1)             # a-posterior density  

#########################################################################

                                                            # figure 6.18 
par(mfrow=c(1,1), lwd=2, bty="n", font.axis=2, ps=15) 
plot(prob, posterior, typ="l", ylab="Density function", 
              ylim=c(0,7), xlab=" ", lty=1, lwd=3, col=4)
lines(prob, prior, lty=3, lwd=3, col=1)
legend(.6, 4, c("a-priori","a-posteriori"), lty=c(3,1), 
                lwd=c(3,3), col=c(1,4), bty="n")

#########################################################################

                                                         # Section 6.19.2

                                # parameter estimation according to Bayes
													
                                                            # figure 6.19														 
par(mfcol=c(1,1), lwd=2, font.axis=2, bty="l", ps=15) 
x <- seq(0, 1, 0.01)
f1 <- dbeta(x, 2, 4, ncp = 0, log = FALSE)
f2 <- dbeta(x, 1, 1, ncp = 0, log = FALSE)
f3 <- dbeta(x, 3, 2, ncp = 0, log = FALSE)
plot(x, f1, type = "l", lty=2, xlim=c(0,1), las=1, 
     xlab=" ", ylab="f(x) a-priori")
lines(x, f2, type = "l", lty=1, xlim=c(0,1))
lines(x, f3, type = "l", lty=3, xlim=c(0,1))
legend("topright", legend = c("Beta(2, 4)","Beta(1, 1)","Beta(3, 2)"),
               lty = c(2,1,3), xjust = 1, yjust = 1, bty="n")

#########################################################################
                                                       
                                                 # parameter estimation    
alpha  <- 0.10; target <- 1 - alpha
qbeta(alpha/2, p.1, q.1)                         # CR - credible interval  
qbeta(1-alpha/2, p.1, q.1)

region <- c(0.1, 0.6)                            # region ...?           
ruler  <- seq(region[1], region[2], length=10000) 
dens   <- round(dbeta(ruler, p.1, q.1), 2)       # a-posteriori Dichte     

start  <- 1; stop <- length(dens)                # HPD - Region            
done   <- FALSE; tol <- 0.01
i <- start;  
while (i < stop & done == FALSE) {
    j <- length(dens)
    while (j > i & done == FALSE) {
        if (dens[i] == dens[j]) {
            L <- pbeta(ruler[i], p.1, q.1)
            H <- pbeta(ruler[j], p.1, q.1)
            if (((H - L) < (target+tol)) & ((H - L) > (target-tol)))
                done <- TRUE
            }
            j <- j - 1
        }
        i <- i + 1
}
k <- dens[i]; HPD.L <- ruler[i]; HPD.H <- ruler[j]
k; HPD.L; HPD.H

#########################################################################

                                                            # figure 6.20
par(mfrow=c(1,1), lwd=2, bty="n", font.axis=2, ps=15) 
plot(prob, posterior, typ="l", ylab="Density", 
                ylim=c(0,7), xlab=" ", lty=1, lwd=3, col=4)
abline(h=k)
lines(c(HPD.L, HPD.L), c(0, dens[i]))
lines(c(HPD.H, HPD.H), c(0, dens[j]))
text(0.85, k + 0.3, paste("k = ",k))
text(0.1, 1, paste("HPD (L):", round(HPD.L, 3)), ps=10)
text(0.6, 1, paste("HPD (H):", round(HPD.H, 3)), ps=10)

##########################################################################
